/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.profiling;

import emulator.assembler.AddressDictionary;
import emulator.hardware.debug.profiling.CodeSegment;
import emulator.shell.GUI.profiling.CallTableModel;
import emulator.shell.GUI.profiling.CallTreeModel;
import emulator.shell.GUI.profiling.CodeTableData;
import emulator.shell.GUI.profiling.CodeTableModel;
import java.util.Collection;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;

public class ProfilingStatisticsVM {
    private CodeTableModel codeTableModel = new CodeTableModel();
    private CallTableModel callTableModel = new CallTableModel();
    private CallTreeModel callTreeModel = new CallTreeModel();

    public TableModel getCodeTableModel() {
        return this.codeTableModel;
    }

    public TableModel getCallTableModel() {
        return this.callTableModel;
    }

    public TreeModel getCallTreeModel() {
        return this.callTreeModel;
    }

    public void addAddressStatistics(int address, int sumTicks, int hitCount, String label) {
        this.codeTableModel.addData(new CodeTableData(address, sumTicks, hitCount, label));
    }

    public void setTotalTicks(long totalTicks) {
        this.codeTableModel.setTotalTicks(totalTicks);
    }

    public int getAddressAtCodeLine(int rowIndex) {
        return this.codeTableModel.getAddressAtRow(rowIndex);
    }

    public int getAddressAtCall(int rowIndex) {
        return this.callTableModel.getAddressAtRow(rowIndex);
    }

    public void prepareCodeSegment(CodeSegment codeSegment, String label) {
        this.callTableModel.prepareCodeSegment(codeSegment, label);
    }

    public void processCodeSegment(CodeSegment codeSegment) {
        this.callTableModel.processCodeSegment(codeSegment);
    }

    public void addTopLevelSegments(Collection<CodeSegment> topLevelSegments, AddressDictionary labelMap) {
        for (CodeSegment codeSegment : topLevelSegments) {
            this.callTreeModel.getRootNode().addChild(codeSegment, labelMap);
        }
    }

    public void postProcess() {
        this.codeTableModel.postProcess();
        this.callTableModel.postProcess();
    }
}

